---
title: m2m100-1.2b · Cloudflare Workers AI docs
description: Multilingual encoder-decoder (seq-to-seq) model trained for
  Many-to-Many multilingual translation
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers-ai/models/m2m100-1.2b/
  md: https://developers.cloudflare.com/workers-ai/models/m2m100-1.2b/index.md
---

![Meta logo](https://developers.cloudflare.com/_astro/meta.x5nlFKBG.svg)

# m2m100-1.2b

Translation • Meta

@cf/meta/m2m100-1.2b

Multilingual encoder-decoder (seq-to-seq) model trained for Many-to-Many multilingual translation

| Model Info | |
| - | - |
| Terms and License | [link](https://github.com/facebookresearch/fairseq/blob/main/LICENSE) |
| More information | [link](https://github.com/facebookresearch/fairseq/tree/main/examples/m2m_100) |
| Batch | Yes |
| Unit Pricing | $0.34 per M input tokens, $0.34 per M output tokens |

## Usage

Workers - TypeScript

```ts
export interface Env {
  AI: Ai;
}


export default {
  async fetch(request, env): Promise<Response> {


    const response = await env.AI.run(
      "@cf/meta/m2m100-1.2b",
      {
        text: "I'll have an order of the moule frites",
        source_lang: "english", // defaults to english
        target_lang: "french",
      }
    );


    return new Response(JSON.stringify(response));
  },
} satisfies ExportedHandler<Env>;
```

Python

```py
import requests


API_BASE_URL = "https://api.cloudflare.com/client/v4/accounts/{ACCOUNT_ID}/ai/run/"
headers = {"Authorization": "Bearer {API_TOKEN}"}


def run(model, input):
    response = requests.post(f"{API_BASE_URL}{model}", headers=headers, json=input)
    return response.json()


output = run('@cf/meta/m2m100-1.2b', {
  "text": "I'll have an order of the moule frites",
  "source_lang": "english",
  "target_lang": "french"
})


print(output)
```

curl

```sh
curl https://api.cloudflare.com/client/v4/accounts/$CLOUDFLARE_ACCOUNT_ID/ai/run/@cf/meta/m2m100-1.2b  \
    -X POST  \
    -H "Authorization: Bearer $CLOUDFLARE_API_TOKEN"  \
    -d '{ "text": "Ill have an order of the moule frites", "source_lang": "english", "target_lang": "french" }'
```

## Parameters

\* indicates a required field

### Input

* `0` object

  * `text` string required min 1

    The text to be translated

  * `source_lang` string default en

    The language code of the source text (e.g., 'en' for English). Defaults to 'en' if not specified

  * `target_lang` string required

    The language code to translate the text into (e.g., 'es' for Spanish)

* `1` object

  * `requests` array required

    Batch of the embeddings requests to run using async-queue

    * `items` object

      * `text` string required min 1

        The text to be translated

      * `source_lang` string default en

        The language code of the source text (e.g., 'en' for English). Defaults to 'en' if not specified

      * `target_lang` string required

        The language code to translate the text into (e.g., 'es' for Spanish)

### Output

* `0` object

  * `translated_text` string

    The translated text in the target language

* `1` object

  * `request_id` string

    The async request id that can be used to obtain the results.

## API Schemas

The following schemas are based on JSON Schema

* Input

  ```json
  {
      "type": "object",
      "oneOf": [
          {
              "properties": {
                  "text": {
                      "type": "string",
                      "minLength": 1,
                      "description": "The text to be translated"
                  },
                  "source_lang": {
                      "type": "string",
                      "default": "en",
                      "description": "The language code of the source text (e.g., 'en' for English). Defaults to 'en' if not specified"
                  },
                  "target_lang": {
                      "type": "string",
                      "description": "The language code to translate the text into (e.g., 'es' for Spanish)"
                  }
              },
              "required": [
                  "text",
                  "target_lang"
              ]
          },
          {
              "properties": {
                  "requests": {
                      "type": "array",
                      "description": "Batch of the embeddings requests to run using async-queue",
                      "items": {
                          "type": "object",
                          "properties": {
                              "text": {
                                  "type": "string",
                                  "minLength": 1,
                                  "description": "The text to be translated"
                              },
                              "source_lang": {
                                  "type": "string",
                                  "default": "en",
                                  "description": "The language code of the source text (e.g., 'en' for English). Defaults to 'en' if not specified"
                              },
                              "target_lang": {
                                  "type": "string",
                                  "description": "The language code to translate the text into (e.g., 'es' for Spanish)"
                              }
                          },
                          "required": [
                              "text",
                              "target_lang"
                          ]
                      }
                  }
              },
              "required": [
                  "requests"
              ]
          }
      ]
  }
  ```

* Output

  ```json
  {
      "type": "object",
      "contentType": "application/json",
      "oneOf": [
          {
              "properties": {
                  "translated_text": {
                      "type": "string",
                      "description": "The translated text in the target language"
                  }
              }
          },
          {
              "type": "object",
              "contentType": "application/json",
              "title": "Async response",
              "properties": {
                  "request_id": {
                      "type": "string",
                      "description": "The async request id that can be used to obtain the results."
                  }
              }
          }
      ]
  }
  ```
