---
title: How-to guides · Cloudflare Sandbox SDK docs
description: These guides show you how to solve specific problems and implement
  features with the Sandbox SDK. Each guide focuses on a particular task and
  provides practical, production-ready solutions.
lastUpdated: 2025-10-21T14:02:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/guides/
  md: https://developers.cloudflare.com/sandbox/guides/index.md
---

These guides show you how to solve specific problems and implement features with the Sandbox SDK. Each guide focuses on a particular task and provides practical, production-ready solutions.

[Run background processes](https://developers.cloudflare.com/sandbox/guides/background-processes/)

[Start and manage long-running services and applications.](https://developers.cloudflare.com/sandbox/guides/background-processes/)

[Use code interpreter](https://developers.cloudflare.com/sandbox/guides/code-execution/)

[Execute Python and JavaScript code with rich outputs.](https://developers.cloudflare.com/sandbox/guides/code-execution/)

[Expose services](https://developers.cloudflare.com/sandbox/guides/expose-services/)

[Create preview URLs and expose ports for web services.](https://developers.cloudflare.com/sandbox/guides/expose-services/)

[Work with Git](https://developers.cloudflare.com/sandbox/guides/git-workflows/)

[Clone repositories, manage branches, and automate Git operations.](https://developers.cloudflare.com/sandbox/guides/git-workflows/)

[Execute commands](https://developers.cloudflare.com/sandbox/guides/execute-commands/)

[Run commands with streaming output, error handling, and shell access.](https://developers.cloudflare.com/sandbox/guides/execute-commands/)

[Manage files](https://developers.cloudflare.com/sandbox/guides/manage-files/)

[Read, write, organize, and synchronize files in the sandbox.](https://developers.cloudflare.com/sandbox/guides/manage-files/)

[Deploy to Production](https://developers.cloudflare.com/sandbox/guides/production-deployment/)

[Set up custom domains for preview URLs in production.](https://developers.cloudflare.com/sandbox/guides/production-deployment/)

[Stream output](https://developers.cloudflare.com/sandbox/guides/streaming-output/)

[Handle real-time output from commands and processes.](https://developers.cloudflare.com/sandbox/guides/streaming-output/)

[WebSocket Connections](https://developers.cloudflare.com/sandbox/guides/websocket-connections/)

[Connect to WebSocket servers running in sandboxes.](https://developers.cloudflare.com/sandbox/guides/websocket-connections/)

## Related resources

* [Tutorials](https://developers.cloudflare.com/sandbox/tutorials/) - Step-by-step learning paths
* [API reference](https://developers.cloudflare.com/sandbox/api/) - Complete method documentation
