---
title: Profile settings · Cloudflare One docs
description: This page lists the profile settings available when configuring a
  predefined or custom DLP profile. You can configure profile settings when you
  create a custom profile or edit profile settings for an existing predefined or
  custom profile.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/advanced-settings/
  md: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/advanced-settings/index.md
---

This page lists the profile settings available when configuring a [predefined](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/) or [custom](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/#build-a-custom-profile) DLP profile. You can configure profile settings when you create a custom profile or [edit profile settings](#edit-profile-settings) for an existing predefined or custom profile.

## Edit profile settings

To edit profile settings for an existing predefined or custom DLP profile:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Profiles**.
2. Choose a profile, then select **Edit**.
3. In **Settings**, configure the [settings](#available-settings) for your profile.
4. Select **Save profile**.

## Available settings

The following advanced detection settings are available for predefined and custom DLP profiles.

### Match count

Match count refers to the number of times that any enabled entry in the profile can be detected before an action is triggered, such as blocking or logging. For example, if you select a match count of 10, the scanned file or HTTP body must contain 11 or more matching strings. Detections do not have to be unique.

### Optical Character Recognition (OCR)

Optical Character Recognition (OCR) analyzes and interprets text within image files. When used with DLP profiles, OCR can detect sensitive data within images your users upload.

OCR supports scanning `.jpg`/`.jpeg` and `.png` files between 4 KB and 1 MB in size. Text is encoded in UTF-8 format, including support for non-Latin characters.

### AI context analysis Beta

Note

AI context analysis only supports Gateway HTTP and HTTPS traffic.

AI context analysis uses a pretrained model to analyze and adjust the confidence in a detection based on its surrounding context. DLP will log any matches that are above your confidence threshold.

DLP redacts any matched text, then submits the context as an AI text embedding vector to [Cloudflare Workers AI](https://developers.cloudflare.com/workers-ai/). Vectors are stored in user-specific private namespaces for up to six months, along with hit count and the [false positive/negative report](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#report-false-and-true-positives-to-ai-context-analysis).

To use AI context analysis:

1. Choose the **Confidence threshold** in a DLP profile.
2. [Add the profile](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/#2-create-a-dlp-policy) to a DLP policy.
3. When configuring the DLP policy, turn on [payload logging](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules).

AI context analysis results will appear in the payload section of your [DLP logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/#4-view-dlp-logs). To improve future detections of sensitive data, you need to [report false and true positives](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#report-false-and-true-positives-to-ai-context-analysis).

### Confidence thresholds

Confidence thresholds indicate how confident Cloudflare DLP is in a DLP detection. DLP determines the confidence by inspecting the content for proximity keywords around the detection.

Confidence threshold is set on the DLP profile. When you select a confidence threshold in Cloudflare One, you will see which DLP entries will be affected by the confidence threshold. Entries that do not reflect a confidence threshold in Cloudflare One are not yet supported or are not applicable.

DLP confidence detections consist of Low, Medium, and High confidence thresholds. DLP will default to Low confidence detections, which are based on regular expressions, require few keywords, and will trigger more often. Medium and High confidence detections require more keywords, will trigger less often, and have a higher likelihood of accuracy.

To change the confidence threshold of a DLP profile:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Data loss prevention** > **Profiles**.
2. Select the profile, then select **Edit**.
3. In **Settings** > **Confidence threshold**, choose a new confidence threshold from the dropdown menu.
4. Select **Save profile**.

Setting the confidence to Low will also consider Medium and High confidence detections as matches. Setting the confidence to Medium or High will filter out lower confidence detections.

#### Gateway detections

For inline detections in Gateway, to display Low and Medium confidence detections but block High confidence detections, Cloudflare recommends creating two HTTP policies. The first policy should use a Low confidence DLP profile with an Allow action. The second policy should use a High confidence DLP profile with a Block action. For example:

| Selector | Operator | Value | Action |
| - | - | - | - |
| DLP Profile | in | *Low Confidence Detections* | Allow |

| Selector | Operator | Value | Action |
| - | - | - | - |
| DLP Profile | in | *High Confidence Detections* | Block |
