---
title: Performance and size optimization for the Cloudflare adapter for Open
  Next · Changelog
description: Update to the latest version of `@opennextjs/cloudflare` to
  automatically benefit from these improvements.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-05-open-next-size/
  md: https://developers.cloudflare.com/changelog/2025-06-05-open-next-size/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Performance and size optimization for the Cloudflare adapter for Open Next

Jun 05, 2025

[Workers](https://developers.cloudflare.com/workers/)

With the release of the Cloudflare adapter for Open Next v1.0.0 in May 2025, we already had followups plans [to improve performance and size](https://blog.cloudflare.com/deploying-nextjs-apps-to-cloudflare-workers-with-the-opennext-adapter/#1-0-and-the-road-ahead).

`@opennextjs/cloudflare` v1.2 released on June 5, 2025 delivers on these enhancements. By removing `babel` from the app code and dropping a dependency on `@ampproject/toolbox-optimizer`, we were able to reduce generated bundle sizes. Additionally, by stopping preloading of all app routes, we were able to improve the cold start time.

This means that users will now see a decrease from 14 to 8MiB (2.3 to 1.6MiB gzipped) in generated bundle size for a Next app created via create-next-app, and typically 100ms faster startup times for their medium-sized apps.

Users only need to update to the latest version of `@opennextjs/cloudflare` to automatically benefit from these improvements.

Note that we published [CVE-2005-6087](https://github.com/opennextjs/opennextjs-cloudflare/security/advisories/GHSA-rvpw-p7vw-wj3m) for a SSRF vulnerability in the `@opennextjs/cloudflare` package. The vulnerability has been fixed from `@opennextjs/cloudflare` v1.3.0 onwards. Please update to any version after this one.
